@echo off
REM Batch file to delete Telly/CBM registry entries
REM WARNING: This will delete all registration and configuration data
REM Run as Administrator if needed

echo ========================================
echo Telly/CBM Registry Cleanup
echo ========================================
echo.
echo WARNING: This will delete all registry entries related to Telly/CBM
echo This includes:
echo   - Registration information
echo   - Expiry date tracking
echo   - Demo mode settings
echo   - User preferences
echo.
set /p confirm="Are you sure you want to continue? (Y/N): "
if /i not "%confirm%"=="Y" (
    echo Operation cancelled.
    pause
    exit /b
)

echo.
echo Deleting registry entries...
echo.

REM Delete OpenGLVB Config entries (main registration tracking)
reg delete "HKCU\Software\VB and VBA Program Settings\OpenGLVB\Config" /v "SyncTimeout2" /f >nul 2>&1
if %errorlevel%==0 (echo [OK] Deleted SyncTimeout2) else (echo [SKIP] SyncTimeout2 not found)

reg delete "HKCU\Software\VB and VBA Program Settings\OpenGLVB\Config" /v "SyncTimeout" /f >nul 2>&1
if %errorlevel%==0 (echo [OK] Deleted SyncTimeout) else (echo [SKIP] SyncTimeout not found)

reg delete "HKCU\Software\VB and VBA Program Settings\OpenGLVB\Config" /v "FlushedWrites" /f >nul 2>&1
if %errorlevel%==0 (echo [OK] Deleted FlushedWrites) else (echo [SKIP] FlushedWrites not found)

reg delete "HKCU\Software\VB and VBA Program Settings\OpenGLVB\Config" /v "SM_FlushedWrites" /f >nul 2>&1
if %errorlevel%==0 (echo [OK] Deleted SM_FlushedWrites) else (echo [SKIP] SM_FlushedWrites not found)

reg delete "HKCU\Software\VB and VBA Program Settings\OpenGLVB\Config" /v "EnableOplocks" /f >nul 2>&1
if %errorlevel%==0 (echo [OK] Deleted EnableOplocks) else (echo [SKIP] EnableOplocks not found)

reg delete "HKCU\Software\VB and VBA Program Settings\OpenGLVB\Config" /v "EnableOpLocks" /f >nul 2>&1
if %errorlevel%==0 (echo [OK] Deleted EnableOpLocks) else (echo [SKIP] EnableOpLocks not found)

REM Delete CBM entries (user preferences)
reg delete "HKCU\Software\CBM" /v "Username" /f >nul 2>&1
if %errorlevel%==0 (echo [OK] Deleted CBM Username) else (echo [SKIP] CBM Username not found)

REM Optional: Delete entire Config folder (uncomment if you want to remove everything)
REM reg delete "HKCU\Software\VB and VBA Program Settings\OpenGLVB\Config" /f >nul 2>&1
REM if %errorlevel%==0 (echo [OK] Deleted entire Config folder) else (echo [SKIP] Config folder not found)

REM Optional: Delete entire OpenGLVB folder (uncomment if you want to remove everything)
REM reg delete "HKCU\Software\VB and VBA Program Settings\OpenGLVB" /f >nul 2>&1
REM if %errorlevel%==0 (echo [OK] Deleted entire OpenGLVB folder) else (echo [SKIP] OpenGLVB folder not found)

REM Optional: Delete entire CBM folder (uncomment if you want to remove everything)
REM reg delete "HKCU\Software\CBM" /f >nul 2>&1
REM if %errorlevel%==0 (echo [OK] Deleted entire CBM folder) else (echo [SKIP] CBM folder not found)

echo.
echo ========================================
echo Registry cleanup completed!
echo ========================================
echo.
echo Note: The License.dll file in the application folder
echo       may also need to be deleted manually.
echo.
pause